"use client";

import React from 'react';
import { BarChart, Bar, XAxis, YAxis, CartesianGrid, Tooltip, ResponsiveContainer } from 'recharts';
import resolveConfig from 'tailwindcss/resolveConfig';
import tailwindConfig from '../../../../tailwind.config'
import { ChartData } from '../types/chart-data';

const fullConfig = resolveConfig(tailwindConfig)
//@ts-expect-error incorrectly interpreting tailwind config schema 
const primaryColor = fullConfig.theme.colors.primary.DEFAULT

interface Props {
  data: ChartData[]
}

const ChartComponent = ({ data }: Props) => {
    return (
      <ResponsiveContainer width="100%" height="100%">
        <BarChart
          width={500}
          height={300}
          data={data}
          margin={{
            top: 5,
            right: 30,
            left: 20,
            bottom: 5,
          }}
        >
          <CartesianGrid strokeDasharray="3 3" />
          <XAxis dataKey="label" style={{ fontSize: '0.75rem' }} />
          <YAxis style={{ fontSize: '0.75rem' }} width={20} />
          <Tooltip />
          <Bar dataKey="visits" fill={primaryColor} />
        </BarChart>
      </ResponsiveContainer>
    );
}

export default ChartComponent;